<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_rfqs', function (Blueprint $table) {
            $table->id();
            $table->string('rfq_no')->unique();
            $table->date('rfq_date');
            $table->unsignedBigInteger('vendor_id');
            $table->string('vendor_reference_no')->nullable();
            $table->string('rfq_type');
            $table->text('description')->nullable();
            $table->text('delivery_terms')->nullable();
            $table->integer('quantity');
            $table->string('uom');
            $table->text('note')->nullable();
            $table->string('status')->default('pending');
            $table->timestamps();

            $table->foreign('vendor_id')->references('id')->on('customer_vendors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_rfqs');
    }
};
