<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_salary_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');
            $table->string('month_year'); // Format: 'MM-YYYY'
            $table->decimal('basic_da', 10, 2)->nullable();
            $table->decimal('hra', 10, 2)->nullable();
            $table->decimal('conveyance', 10, 2)->nullable();
            $table->decimal('washing_allowance', 10, 2)->nullable();
            $table->decimal('fixed_salary', 10, 2)->nullable();
            $table->integer('no_of_days_worked')->nullable();
            $table->integer('leave_given')->nullable();
            $table->integer('total_days_for_salary')->nullable();
            $table->decimal('drawn_salary', 10, 2)->nullable();
            $table->decimal('incentive_hrs', 10, 2)->nullable();
            $table->decimal('incentive_rate', 10, 2)->nullable();
            $table->decimal('incentive_amount', 10, 2)->nullable();
            $table->decimal('attendance_bonus', 10, 2)->nullable();
            $table->decimal('gross_salary', 10, 2)->nullable();
            $table->decimal('esi', 10, 2)->nullable();
            $table->decimal('pf', 10, 2)->nullable();
            $table->decimal('pt', 10, 2)->nullable();
            $table->decimal('advance_deduction', 10, 2)->nullable();
            $table->decimal('net_salary', 10, 2)->nullable();
            $table->string('payment_mode')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_salary_details');
    }
};
