<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('manufacturing_plans', function (Blueprint $table) {
            $table->id();
            $table->string('rc_id');
            $table->string('company_name');
            $table->string('status')->default('Ready to plan');
            $table->date('rc_date')->nullable();
            $table->string('approved_by')->nullable();
            $table->string('plan_by')->nullable();
            $table->date('plan_date')->nullable();
            // For planned projects:
            $table->string('machine')->nullable();
            $table->string('process')->nullable();
            $table->string('operator')->nullable();
            $table->string('ct_hours')->nullable();
            $table->string('ct_minutes')->nullable();
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('manufacturing_plans');
    }
};
