<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quality_controls', function (Blueprint $table) {
            $table->id();
            $table->string('customer');
            $table->string('project_no');
            $table->string('material_no');
            $table->string('part_no');
            $table->string('drawing_certification');
            $table->string('document_type');
            $table->string('document_value');
            $table->string('revision');
            $table->integer('sl_no');
            $table->string('drawing_position');
            $table->string('parameter');
            $table->string('description');
            $table->string('drawing_value');
            $table->string('tolerance');
            $table->string('measurement_value1');
            $table->string('measurement_value2')->nullable();
            $table->text('remarks')->nullable();
            $table->string('status'); // Pending, In Progress, Completed, Approved
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quality_controls');
    }
};
