<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sku_movements', function (Blueprint $table) {
            $table->id();
            $table->string('reference')->unique();
            $table->unsignedBigInteger('sku_id');
            $table->string('product');
            $table->enum('type', ['inbound', 'outbound', 'transfer', 'adjustment']);
            $table->integer('quantity');
            $table->string('from_location')->nullable();
            $table->string('to_location')->nullable();
            $table->dateTime('date');
            $table->enum('status', ['completed', 'pending', 'cancelled']);
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sku_movements');
    }
};
