<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sku_approvals', function (Blueprint $table) {
            $table->id();
            $table->string('customer');
            $table->text('items');
            $table->date('date');
            $table->date('approved_date')->nullable();
            $table->string('status')->default('Pending');
            $table->date('action_date')->nullable();
            $table->string('action_by')->nullable();
            $table->string('created_by');
            $table->string('stock_status')->default('In Stock');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sku_approvals');
    }
};
