<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_orders', function (Blueprint $table) {
            $table->id();
            $table->string('purchase_order_no')->unique();
            $table->date('purchase_order_date');
            $table->string('grn_no')->nullable();
            $table->string('quotation_no')->nullable();
            $table->date('quotation_date')->nullable();
            $table->string('customer_ref_no')->nullable();
            $table->string('company_name'); // This should be ID if related to CustomerVendor
            $table->string('company_address')->nullable();
            $table->string('company_gstn')->nullable();
            $table->string('company_phone')->nullable();
            $table->string('company_email')->nullable();
            $table->text('bill_address')->nullable();
            $table->text('ship_address')->nullable();
            $table->string('product_type')->nullable();
            $table->string('inr_in_words')->nullable();
            $table->decimal('subtotal', 15, 2)->default(0);
            $table->decimal('sgst_amount', 15, 2)->default(0);
            $table->decimal('cgst_amount', 15, 2)->default(0);
            $table->decimal('igst_amount', 15, 2)->default(0);
            $table->decimal('round_up', 15, 2)->default(0);
            $table->decimal('grand_total', 15, 2)->default(0);
            $table->string('rfq_no')->nullable();
            $table->date('rfq_date')->nullable();
            $table->string('part_no')->nullable();
            $table->string('project_material_no')->nullable();
            $table->string('drawing_no')->nullable();
            $table->string('drawing_rev')->nullable();
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_orders');
    }
};
