<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('raw_materials', function (Blueprint $table) {
            $table->id();
            $table->string('rm_grade');                  // Raw Material Name
            $table->string('iso_specification');     // ISO Specification
            $table->string('density')->nullable();   // Material Density
            $table->string('raw_material_type')->nullable(); // Mechanical Properties
            //$table->string('material_file')->nullable(); // Mechanical Properties
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('raw_materials');
    }
};
