<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRouteCardProcessesTable extends Migration
{
    public function up()
    {
        Schema::create('route_card_processes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('route_card_id')->constrained()->onDelete('cascade');
            $table->string('process');
            $table->string('machine');
            $table->string('operator');
            $table->integer('cycle_hours')->nullable();
            $table->integer('cycle_minutes')->nullable();
            $table->enum('source', ['inhouse', 'outsourced'])->default('inhouse');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('route_card_processes');
    }
}
