<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRouteCardsTable extends Migration
{
    public function up()
    {
        Schema::create('route_cards', function (Blueprint $table) {
            $table->id();
            $table->string('route_no');
            $table->date('route_date');
            $table->string('grn_no')->nullable();
            $table->date('grn_date')->nullable();
            $table->string('order_no')->nullable();
            $table->date('order_date')->nullable();
            $table->string('company_name')->nullable();
            $table->string('company_address')->nullable();
            $table->string('company_gstn')->nullable();
            $table->string('company_email')->nullable();
            $table->string('company_phone')->nullable();
            $table->string('order_ref_no')->nullable();
            $table->string('quotation_no')->nullable();
            $table->date('quotation_date')->nullable();
            $table->string('rfq_no')->nullable();
            $table->date('rfq_date')->nullable();
            $table->string('part_no')->nullable();
            $table->string('project_material_no')->nullable();
            $table->string('drawing_no')->nullable();
            $table->string('drawing_rev')->nullable();
            $table->text('description')->nullable();
            $table->string('product_type')->nullable();
            $table->string('created_by')->nullable();
            // You will want a separate table for processes (for each process row in your form)
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('route_cards');
    }
}
