<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('machines', function (Blueprint $table) {
            $table->id();
            $table->string('machine_id')->unique();
            $table->string('machine_name')->nullable();
            $table->string('machine_sl_no');
            $table->string('make')->nullable();
            $table->string('model_type')->nullable();
            $table->decimal('diameter', 8, 2);
            $table->decimal('length', 8, 2);
            $table->decimal('weight', 8, 2);
            $table->text('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('machines');
    }
};
