<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grns', function (Blueprint $table) {
            $table->id();
            $table->string('grn_no')->unique();
            $table->date('grn_date');
            $table->string('order_no');
            $table->date('order_date');
            $table->string('order_ref_no')->nullable();
            $table->string('company_name');
            $table->string('company_address')->nullable();
            $table->string('company_gst')->nullable();
            $table->string('company_phone')->nullable();
            $table->string('company_email')->nullable();
            $table->string('quotation_no')->nullable();
            $table->date('quotation_date')->nullable();
            $table->string('rfq_no')->nullable();
            $table->date('rfq_date')->nullable();
            $table->string('part_no')->nullable();
            $table->string('project_material_no')->nullable();
            $table->string('drawing_no')->nullable();
            $table->string('drawing_rev')->nullable();
            $table->text('description')->nullable();
            $table->string('product_type')->nullable();
            $table->string('challan_file')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grns');
    }
};
