<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_leaves', function (Blueprint $table) {
            $table->id();
            $table->string('employee_id');
            $table->string('employee_name');
            $table->string('department');
            $table->string('leave_type');
            $table->date('leave_from');
            $table->date('leave_to');
            $table->decimal('number_of_days', 5, 2);
            $table->string('duration_type');
            $table->string('status');
            $table->text('reason');
            $table->dateTime('requested_on')->nullable();
            $table->string('approved_by')->nullable();
            $table->dateTime('approval_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_employee_leaves');
    }
};
