<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_daily_reports', function (Blueprint $table) {
    $table->id();
    $table->date('date');
    $table->string('employee_id');
    $table->string('shift')->nullable();
    $table->string('in_spfid_1')->nullable();
    $table->string('out_spfid_1')->nullable();
    $table->string('in_spfid_2')->nullable();
    $table->string('out_spfid_2')->nullable();
    $table->string('first_half')->nullable();
    $table->string('second_half')->nullable();
    $table->string('late_in')->nullable();
    $table->string('early_out')->nullable();
    $table->string('hourly_paid_leave')->nullable();
    $table->string('hourly_unpaid_leave')->nullable();
    $table->string('over_time')->nullable();
    $table->string('auth_ot')->nullable();
    $table->string('auth_coff')->nullable();
    $table->string('work_hours')->nullable();
    $table->string('man_entry')->nullable();
    $table->string('reason')->nullable();
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_daily_reports');
    }
};
