<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('employee_attendances', function (Blueprint $table) {
            $table->id();
            $table->string('month_year'); // e.g., "June, 2025"
            $table->string('employee_name');
            $table->string('employee_id');
            $table->string('gender')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->date('date_of_joining')->nullable();
            $table->string('department')->nullable();
            $table->string('designation')->nullable();
            $table->integer('days_worked')->default(0);
            $table->integer('sundays_eligible')->default(0);
            $table->integer('holidays')->default(0);
            $table->integer('leave_enjoyed')->default(0);
            $table->integer('total_paid_days')->default(0);
            $table->integer('absent')->default(0);
            $table->integer('first_shifts')->default(0);
            $table->integer('night_shifts')->default(0);
            $table->float('ot_hours')->default(0);
            $table->float('shortage_hours')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_attendances');
    }
};
