<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('skumaster', function (Blueprint $table) {
            $table->id();
            $table->string('item_name');
            $table->string('category');
            $table->string('uom');
            $table->decimal('tax_rate', 5, 2);
            $table->integer('current_stock');
            $table->decimal('default_price', 10, 2);
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('tcs', 5, 2)->nullable();
            $table->integer('min_order_level');
            $table->integer('max_order_level');
            $table->string('hsn_code')->nullable();
            $table->string('supplier_name')->nullable();
            $table->string('supplier_phone')->nullable();
            $table->string('supplier_email')->nullable();
            $table->text('reason')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('skumaster');
    }
};
