<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tax_invoices', function (Blueprint $table) {
    $table->id();
    $table->string('invoice_no')->unique();
    $table->date('invoice_date');
    $table->string('delivery_note')->nullable();
    $table->string('terms_payment')->nullable();
    $table->string('reference_no')->nullable();
    $table->string('other_reference')->nullable();
    $table->unsignedBigInteger('company_id'); // Foreign Key
    $table->text('address');
    $table->string('gst');
    $table->string('phone');
    $table->string('email');
    $table->string('buyer_order_no')->nullable();
    $table->date('reference_date')->nullable();
    $table->string('dispatch_through')->nullable();
    $table->string('destination')->nullable();
    $table->string('vehicle_no')->nullable();
    $table->string('terms_of_delivery')->nullable();

    // Calculated values
    $table->decimal('taxable_value', 10, 2)->default(0);
    $table->decimal('sgst', 10, 2)->default(0);
    $table->decimal('cgst', 10, 2)->default(0);
    $table->decimal('igst', 10, 2)->default(0);
    $table->decimal('total_tax_amount', 10, 2)->default(0);
    $table->decimal('total_amount', 10, 2)->default(0);
    $table->string('amount_in_words')->nullable();

    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tax_invoice');
    }
};
