<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuotationsTable extends Migration
{
    public function up()
    {
        Schema::create('quotations', function (Blueprint $table) {
            $table->id();
            $table->string('quotation_no');
            $table->date('quotation_date');
            $table->string('customer_name');
            $table->text('address');
            $table->string('gst')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('cust_ref_no')->nullable();
            $table->string('rfq_no')->nullable();
            $table->date('rfq_date')->nullable();
            $table->string('part_no')->nullable();
            $table->string('project_material_no')->nullable();
            $table->string('drawing_no')->nullable();
            $table->string('drawing_rev')->nullable();
            $table->integer('quantity')->nullable();
            $table->string('quantity_uom')->nullable();
            $table->text('description')->nullable();
            $table->string('product_type')->nullable();
            $table->text('note')->nullable();
            $table->decimal('sub_total', 15, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('round_up', 15, 2)->nullable();
            $table->decimal('grand_total', 15, 2)->nullable();
            $table->json('raw_materials')->nullable();
            $table->json('conversion_costs')->nullable();
            $table->json('packing_charges')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('quotations');
    }
}
