<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRfqsTable extends Migration
{
    public function up()
    {
        Schema::create('rfqs', function (Blueprint $table) {
            $table->id();
            $table->string('rfq_no');
            $table->date('rfq_date');
            $table->string('customer');
            $table->string('cus_ref_no')->nullable();
            $table->string('rfq_type');
            $table->string('product_type');
            $table->string('part_no');
            $table->string('project_material_no');
            //$table->string('drawing_file')->nullable();
            $table->string('drawing_no');
            $table->string('drawing_rev');
            //$table->string('material_specification_file')->nullable();
            //$table->string('rfq_form_file')->nullable();
            $table->integer('quantity');
            $table->string('uom');
            $table->text('note')->nullable();
            //$table->string('annexure_file')->nullable();
            $table->string('raw_material');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('rfqs');
    }
}
