<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomerVendorsTable extends Migration
{
    public function up()
    {
        Schema::create('customer_vendors', function (Blueprint $table) {
            $table->id();
            $table->string('company_role');
            $table->string('company');
            $table->string('email')->unique();
            $table->string('company_nickname')->nullable();
            $table->string('image')->nullable();
            $table->string('mobile');
            $table->string('company_type');
            $table->string('gstno')->unique();
            $table->string('panno')->unique();
            $table->string('msmeno')->nullable();
            $table->string('iecno')->nullable();
            $table->text('billingAddress')->nullable();
            $table->text('shippingAddress')->nullable();
            $table->string('url')->nullable();
            $table->string('bank_name');
            $table->string('branch_name');
            $table->string('account_number');
            $table->string('account_type');
            $table->string('account_holder_name');
            $table->string('account_currency')->default('INR');
            $table->string('ifsc_code');
            $table->string('swift_code')->nullable();
            $table->string('person_name');
            $table->string('person_email');
            $table->string('person_mobile');
            $table->string('person_designation')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('customer_vendors');
    }
}
