<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('purchase_quotations', function (Blueprint $table) {
            $table->id();
            $table->string('quotation_no')->unique();
            $table->date('quotation_date');
            $table->string('vendor_name');
            $table->unsignedBigInteger('vendor_id')->nullable();
            $table->text('address')->nullable();
            $table->string('gst')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->string('rfq_no')->nullable();
            $table->decimal('additional_charges', 15, 2)->nullable();
            $table->date('rfq_date')->nullable();
            $table->string('vendor_reference_no')->nullable();
            $table->string('delivery_terms')->nullable();
            $table->string('part_no')->nullable();
            $table->string('project_material_no')->nullable();
            $table->string('drawing_no')->nullable();
            $table->string('drawing_rev')->nullable();
            $table->decimal('quantity', 15, 2)->nullable();
            $table->string('quantity_uom')->nullable();
            $table->text('note')->nullable();
            $table->text('description')->nullable();
            $table->decimal('sub_total', 15, 2)->nullable();
            $table->decimal('discount', 8, 2)->nullable();
            $table->decimal('round_up', 15, 2)->nullable();
            $table->decimal('grand_total', 15, 2)->nullable();
            $table->string('inr_in_words')->nullable();
            $table->string('status')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('purchase_quotations');
    }
}; 