<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TaxInvoiceItem extends Model
{
    protected $table = 'tax_invoice_items'; // if table name is not pluralized correctly
    protected $fillable = [
        'tax_invoice_id',
        'description',
        'hsn',
        'quantity',
        'rate',
        'per',
        'sgst',
        'cgst',
        'igst',
        'amount',
    ];

    public function invoice()
    {
        return $this->belongsTo(TaxInvoice::class, 'tax_invoice_id');
    }
}
