<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TaxInvoice extends Model
{
    protected $table = 'tax_invoices'; // if table name is not pluralized correctly
    protected $fillable = [
        'invoice_no',
        'invoice_date',
        'delivery_note',
        'terms_payment',
        'reference_no',
        'other_reference',
        'company_id',
        'address',
        'gst',
        'phone',
        'email',
        'buyer_order_no',
        'reference_date',
        'dispatch_through',
        'destination',
        'vehicle_no',
        'terms_of_delivery',
        'taxable_value',
        'sgst',
        'cgst',
        'igst',
        'total_tax_amount',
        'total_amount',
        'amount_in_words'
    ];

    public function items()
    {
        return $this->hasMany(TaxInvoiceItem::class);
    }

    public function company()
    {
        return $this->belongsTo(CustomerVendor::class, 'company_id');
    }
}
