<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SkuApproval extends Model
{
    use HasFactory;

    protected $fillable = [
        'customer_id',
        'items',
        'date',
        'approved_date',
        'status',
        'action_date',
        'action_by',
        'created_by',
        'stock_status'
    ];

    protected $casts = [
        'items' => 'array', // to automatically cast to/from JSON
        'date' => 'date',
        'approved_date' => 'date',
        'action_date' => 'date',
    ];

    public function customer()
    {
        return $this->belongsTo(CustomerVendor::class, 'customer_id');
    }
}
