<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SalesPayment extends Model
{
    protected $table = 'sales_payments';

    protected $fillable = [
        'payment_no',
        'invoice_id',
        'invoice_no',
        'party_id',
        'payment_date',
        'payment_amount',
        'payment_method',
        'reference_no',
        'notes'
    ];

    protected $casts = [
        'payment_date' => 'date',
        'payment_amount' => 'decimal:2'
    ];

    public function invoice()
    {
        return $this->belongsTo(TaxInvoice::class, 'invoice_id');
    }

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'party_id');
    }
}
