<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesOrderItem extends Model
{
    use HasFactory;
    protected $table = 'sales_order_items';

    protected $fillable = [
        'sales_order_id',
        'sl_no',
        'material_code',
        'hsn_code',
        'material_description',
        'additional_details',
        'required_by_date',
        'quantity',
        'uom',
        'unit_rate',
        'discount',
        'value',
        'sgst',
        'cgst',
        'igst',
        'amount'
    ];

    public function salesOrder()
    {
        return $this->belongsTo(SalesOrder::class);
    }
}
