<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalesOrder extends Model
{
    use HasFactory;
    

    protected $fillable = [
        'sales_order_no',
        'sales_order_date',
        'grn_no',
        'customer_ref_no',
        'company_name',
        'company_address',
        'company_gstn',
        'company_phone',
        'company_email',
        'quotation_no',
        'quotation_date',
        'rfq_no',
        'rfq_date',
        'part_no',
        'project_material_no',
        'drawing_no',
        'drawing_rev',
        'description',
        'bill_address',
        'ship_address',
        'product_type',
        'inr_in_words',
        'subtotal',
        'sgst_amount',
        'cgst_amount',
        'igst_amount',
        'round_up',
        'grand_total',
        'status'
    ];

    // Define Items relationship
    public function items()
    {
        return $this->hasMany(SalesOrderItem::class, 'sales_order_id');
    }

    // Define Customer relationship
    public function customer()
    {
        return $this->belongsTo(CustomerVendor::class, 'company_name', 'id');
    }
    public function quotation()
{
    return $this->belongsTo(Quotation::class, 'quotation_no', 'quotation_no');
}
 public function routeCard() {
        return $this->hasOne(RouteCard::class, 'order_no','sales_order_no');
    }
    
}
