<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SalesDebitNote extends Model
{
    protected $table = 'sales_debit_notes';

    protected $fillable = [
        'debit_note_no',
        'date',
        'invoice_no',
        'party_id',
        'amount',
        'reason',
        'description'
    ];

    protected $casts = [
        'date' => 'date',
        'amount' => 'decimal:2'
    ];

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'party_id');
    }

    // Optional: Link to invoice via invoice_no if possible
    public function invoice()
    {
        return $this->belongsTo(TaxInvoice::class, 'invoice_no', 'invoice_no');
    }
}
