<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SalesCreditNote extends Model
{
    protected $table = 'sales_credit_notes';

    protected $fillable = [
        'credit_note_no',
        'date',
        'invoice_no',
        'party_id',
        'amount',
        'reason',
        'description'
    ];

    protected $casts = [
        'date' => 'date',
        'amount' => 'decimal:2'
    ];

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'party_id');
    }

    public function invoice()
    {
        return $this->belongsTo(TaxInvoice::class, 'invoice_no', 'invoice_no');
    }
}
