<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RouteCard extends Model
{
    use HasFactory;

    protected $table = 'route_cards';

    protected $fillable = [
        'route_no',
        'route_date',
        'grn_no',
        'grn_date',
        'order_no',
        'order_date',
        'company_name',
        'company_address',
        'company_gstn',
        'company_email',
        'company_phone',
        'order_ref_no',
        'quotation_no',
        'quotation_date',
        'rfq_no',
        'rfq_date',
        'part_no',
        'project_material_no',
        'drawing_no',
        'drawing_rev',
        'description',
        'product_type',
        'project_start_date',
        'created_by',
        'status',
        'approved_by',
        'approved_at',
        'priority',
        'approval_status'
    ];

    public function processes()
{
    return $this->hasMany(RouteCardProcess::class, 'route_card_id');
}


    public function salesOrder()
    {
        return $this->belongsTo(SalesOrder::class, 'order_no', 'sales_order_no')->with('customer');
    }
    
}
