<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RawMaterialFile extends Model
{
    use HasFactory;

    // Explicitly define the table name
    protected $table = 'raw_material_files';

    // Define fillable fields for mass assignment
    protected $fillable = [
        'raw_material_id',
        'file_path',
        'file_name',
    ];

    // Relationship to RawMaterial
    public function rawMaterial()
    {
        return $this->belongsTo(RawMaterial::class);
    }
}
