<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Quotation extends Model
{
    use HasFactory;

    protected $fillable = [
        'quotation_no',
        'quotation_date',
        'customer_name',
        'address',
        'gst',
        'phone',
        'email',
        'cust_ref_no',
        'rfq_no',
        'rfq_date',
        'part_no',
        'project_material_no',
        'drawing_no',
        'drawing_rev',
        'quantity',
        'quantity_uom',
        'description',
        'product_type',
        'note',
        'sub_total',
        'discount',
        'round_up',
        'grand_total',
        'raw_materials',
        'conversion_costs',
        'packing_charges',
    ];

    protected $casts = [
        'raw_materials' => 'array',
        'conversion_costs' => 'array',
        'packing_charges' => 'array',
    ];
    public function customer()
    {
        return $this->belongsTo(CustomerVendor::class, 'customer_name', 'id');
    }
    public function rfq()
    {
        return $this->belongsTo(Rfq::class, 'rfq_no', 'id');
    }
    public function scopeNonVendor($query, $companyId = null)
    {
        return $query->whereHas('customer', function ($q) use ($companyId) {
            $q->where('company_role', '!=', 'Vendor');
            if ($companyId) {
                $q->where('id', $companyId);
            }
        });
    }
}
