<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QcApproval extends Model
{
    protected $fillable = [
        'process_id', 'level', 'status', 'approved_by', 'approved_at', 'remarks',
        'stage', 'parameters', 'rejection_reason'
    ];

    protected $casts = [
        'parameters' => 'array',
    ];

    public function process()
    {
        return $this->belongsTo(RouteCardProcess::class, 'process_id');
    }
}
