<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseQuotationItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'purchase_quotation_id',
        'sl_no',
        'stock_item',
        'stock_item_name',
        'description',
        'quantity',
        'uom',
        'supply_lead_time',
        'unit_rate',
        'tds',
        'discount',
        'value',
        'sgst',
        'cgst',
        'igst',
        'amount',
    ];

    protected $casts = [
        // 'supply_lead_time' => 'date',
        'quantity' => 'decimal:2',
        'unit_rate' => 'decimal:2',
        'tds' => 'decimal:2',
        'discount' => 'decimal:2',
        'value' => 'decimal:2',
        'sgst' => 'decimal:2',
        'cgst' => 'decimal:2',
        'igst' => 'decimal:2',
        'amount' => 'decimal:2',
    ];

    // Relationship back to purchase quotation
    public function purchaseQuotation()
    {
        return $this->belongsTo(PurchaseQuotation::class);
    }

    // Relationship to stock item
    public function stockItem()
    {
        return $this->belongsTo(\App\Models\StockItem::class, 'stock_item');
    }
} 