<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseDebitNote extends Model
{
    protected $fillable = [
        'debit_note_no', 'date', 'invoice_no', 'party_id', 'amount', 'reason', 'description'
    ];

    public function party()
    {
        return $this->belongsTo(CustomerVendor::class, 'party_id');
    }

    public function purchase()
    {
        return $this->belongsTo(Purchase::class, 'invoice_no', 'invoice_no');
    }
}
