<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Process extends Model
{
    protected $fillable = ['product_type_id', 'name', 'order'];

    public function productType()
    {
        return $this->belongsTo(ProductType::class);
    }

    public function machines()
    {
        return $this->belongsToMany(Machines::class, 'process_machine', 'process_id', 'machine_id')->withTimestamps();
    }

    public function operators()
    {
        //return $this->belongsToMany(EmployeeDetails::class, 'process_operator', 'process_id', 'employee_id')->withTimestamps();

        // here we need fetch the operators who are assigned to the machines used in this process
        return $this->belongsToMany(EmployeeDetails::class, 'machine_operator', 'machine_id', 'employee_id')
            ->join('process_machine', 'machine_operator.machine_id', '=', 'process_machine.machine_id')
            ->where('process_machine.process_id', $this->id)
            ->withTimestamps();
    }
}
