<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrnItem extends Model
{
    use HasFactory;

    protected $table = 'grn_items';

    protected $fillable = [
        'grn_order_id',
        'description',
        'quantity',
        'uom',
        'date',
        'supplier',
        'remarks',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function grnOrder()
    {
        return $this->belongsTo(GrnOrder::class);
    }
}
