<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Grn extends Model
{
    protected $table = 'grns';
    protected $fillable = [
        'grn_no', 'grn_date', 'order_no', 'order_date', 'order_ref_no',
        'company_name', 'company_address', 'company_gst', 'company_phone', 'company_email',
        'quotation_no', 'quotation_date', 'rfq_no', 'rfq_date', 'part_no',
        'project_material_no', 'drawing_no', 'drawing_rev', 'description',
        'product_type', 'challan_file', 'status'
    ];

    public function products()
    {
        return $this->hasMany(GrnProductDetail::class, 'grn_id');
    }
}
