<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EmployeeDailyReport extends Model
{
    protected $table = 'employee_daily_reports';
    protected $fillable = [
        'date',
        'employee_id',
        'shift',
        'in_spfid_1',
        'out_spfid_1',
        'in_spfid_2',
        'out_spfid_2',
        'first_half',
        'second_half',
        'late_in',
        'early_out',
        'hourly_paid_leave',
        'hourly_unpaid_leave',
        'over_time',
        'auth_ot',
        'auth_coff',
        'work_hours',
        'man_entry',
        'reason',
    ];
    public function employeeDetails()
    {
        return $this->belongsTo(\App\Models\EmployeeDetails::class, 'employee_id', 'employee_id');
    }
}
