<?php
namespace App\Http\Controllers\V1;


use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use App\Models\Machines;
use App\Models\Process;
use App\Models\ProductType;
use App\Models\RouteCard;
use App\Models\SalesOrder;
use App\Models\RouteCardProcess;

use Carbon\Carbon;
use Exception;



class SaleOrderController extends Controller
{
    public function index(Request $request)
    {
        $saleOrders = SalesOrder::with(['items','customer','quotation'])->get();
        return view('superadmin.routecard.routecardorder', compact('saleOrders'));
    }

    public function planning(Request $request)
    {
        $tab = $request->query('tab', 'r2plan');
        // $read2PlanOrders = SalesOrder::with([
        //         'items',
        //         'customer',
        //         'quotation',
        //         'routeCard'
        // ])->select('sales_orders.*')
        // ->leftJoin('route_cards', 'sales_orders.sales_order_no', '=', 'route_cards.order_no')
        // ->leftJoin('route_card_processes', 'route_cards.id', '=', 'route_card_processes.route_card_id')
        // ->groupBy('sales_orders.id')
        // ->havingRaw('COUNT(route_card_processes.id) = 0')
        // ->get();
        // Step 1: Get valid SalesOrder IDs
        $filteredIds = DB::table('sales_orders')
            ->leftJoin('route_cards', 'sales_orders.sales_order_no', '=', 'route_cards.order_no')
            ->leftJoin('route_card_processes', 'route_cards.id', '=', 'route_card_processes.route_card_id')
            ->select('sales_orders.id')
            ->groupBy('sales_orders.id')
            ->havingRaw('COUNT(route_card_processes.id) = 0')
            ->pluck('sales_orders.id');

        // Step 2: Load full SalesOrder models with relationships
        $read2PlanOrders = SalesOrder::with(['items', 'customer', 'quotation', 'routeCard'])
            ->whereIn('id', $filteredIds)
            ->get();


        // $planningOrders = SalesOrder::with(['items','customer','quotation','routeCard','routeCard.processes'])
        // ->select('sales_orders.*')
        // ->join('route_cards', 'sales_orders.sales_order_no', '=', 'route_cards.order_no')
        // ->leftJoin('route_card_processes', 'route_cards.id', '=', 'route_card_processes.route_card_id')
        // ->groupBy('sales_orders.id')
        // ->havingRaw('COUNT(route_card_processes.id) > 0')
        // ->get();
        // return view('v1.manufacturing.planning', ['read2PlanOrders' => $read2PlanOrders,
        // 'planningOrders' => $planningOrders,
        // 'request' => $request ]);
        // / Step 1: Get IDs of sales orders with at least one route_card_process
        $planningOrderIds = DB::table('sales_orders')
            ->join('route_cards', 'sales_orders.sales_order_no', '=', 'route_cards.order_no')
            ->leftJoin('route_card_processes', 'route_cards.id', '=', 'route_card_processes.route_card_id')
            ->select('sales_orders.id')
            ->groupBy('sales_orders.id')
            ->havingRaw('COUNT(route_card_processes.id) > 0')
            ->pluck('sales_orders.id');

        // Step 2: Load full SalesOrder models with relationships
        $planningOrders = SalesOrder::with([
            'items',
            'customer',
            'quotation',
            'routeCard',
            'routeCard.processes'
        ])
            ->whereIn('id', $planningOrderIds)
            ->get();

        return view('v1.manufacturing.planning', [
            'read2PlanOrders' => $read2PlanOrders,
            'planningOrders' => $planningOrders,
            'request' => $request
        ]);

    }
}

?>