<?php

namespace App\Http\Controllers\SuperAdmin;
use App\Http\Controllers\Controller;

use App\Models\Category;
use App\Models\StockItem;
use Illuminate\Http\Request;

use App\Imports\StockItemsImport;
use Maatwebsite\Excel\Facades\Excel;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Validator;

class SuperAdminStockItemsController extends Controller
{
    public function index()
    {
        $categories = Category::all();
        $stockItems = StockItem::with('category')->get();
        return view('superadmin.master.stockitems', compact('categories', 'stockItems'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'category_id' => 'required|exists:categories,id',
            'item_name'   => 'required|string|unique:stock_items,item_name',
            'uom'         => 'nullable|string',
            'sgst'        => 'nullable|numeric',
            'cgst'        => 'nullable|numeric',
            'igst'        => 'nullable|numeric',
        ]);
    
        /*
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => 'Validation failed.',
                'errors'  => $validator->errors(),
            ], 422);
        }
        */
        
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput()
                ->with('show_main_modal', true); // flag to re-open modal
        }

        StockItem::create($request->all());
        return redirect()->back()->with('success', 'Item added successfully!');
    }

    public function update(Request $request, $id)
    {
        $item = StockItem::findOrFail($id);
    
        $validator = Validator::make($request->all(), [
            'category_id' => 'required|exists:categories,id',
            'item_name'   => 'required|string|unique:stock_items,item_name,' . $item->id,
            'uom'         => 'nullable|string',
            'sgst'        => 'nullable|numeric',
            'cgst'        => 'nullable|numeric',
            'igst'        => 'nullable|numeric',
        ]);
    
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput()
                ->with('edit_item_id', $id); // used for showing modal again
        }
    
        $item->update($request->all());
    
        return redirect()->back()->with('success', 'Item updated successfully!');
    }

    public function destroy($id)
    {
        $item = StockItem::findOrFail($id);
        $item->delete();
        return redirect()->back()->with('success', 'Item deleted successfully!');
    }

    public function storeCategory(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:categories,name',
        ]);
    
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput()
                ->with('show_category_modal', true); // flag to re-open modal
        }

        Category::create(['name' => $request->name]);
        return redirect()->back()->with('success', 'Category added successfully!');
    }

    public function importExcel(Request $request)
    {
        $request->validate([
            'excel_file' => 'required|mimes:xlsx,xls,csv',
        ]);
    
        Excel::import(new StockItemsImport, $request->file('excel_file'));
    
        return redirect()->back()->with('success', 'Stock items imported successfully!');
    }
    public function purchaseQuotationItems()
    {
    // Explicitly specify foreign key
    return $this->hasMany(PurchaseQuotationItem::class, 'stock_item');
    }
    
}
