<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\RfqType;

class RfqTypeController extends Controller
{
    public function index()
    {
        return view('admin.master.rfqtype');
    }

    public function list()
    {
        $types = RfqType::select('id', 'rfqtype')->get();
        return response()->json(['data' => $types]);
    }

    public function show(RfqType $rfqtype)
    {
        return response()->json($rfqtype);
    }

    public function store(Request $request)
    {
        $request->validate(['rfq_type' => 'required']);
        RfqType::create(['rfqtype' => $request->rfq_type]);
        return response()->json(['success' => true, 'message' => 'RFQ Type added']);
    }

    public function update(Request $request, RfqType $rfqtype)
    {
        $request->validate(['rfq_type' => 'required']);
        $rfqtype->update(['rfqtype' => $request->rfq_type]);
        return response()->json(['success' => true, 'message' => 'RFQ Type updated']);
    }

    public function delete(RfqType $rfqtype)
    {
        $rfqtype->delete();
        return response()->json(['success' => true, 'message' => 'RFQ Type deleted']);
    }
}
