<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductType;

class ProductTypeController extends Controller
{
    public function index()
    {
        return view('admin.master.producttype');
    }

    public function list()
    {
        $types = ProductType::select('id', 'name')->get();
        return response()->json(['data' => $types]);
    }

    public function show(ProductType $producttype)
    {
        return response()->json($producttype);
    }

    public function store(Request $request)
    {
        $request->validate(['product_type' => 'required']);
        ProductType::create(['name' => $request->product_type]);
        return response()->json(['success' => true, 'message' => 'Product Type added']);
    }

    public function update(Request $request, ProductType $producttype)
    {
        $request->validate(['product_type' => 'required']);
        $producttype->update(['name' => $request->product_type]);
        return response()->json(['success' => true, 'message' => 'Product Type updated']);
    }

    public function delete(ProductType $producttype)
    {
        $producttype->delete();
        return response()->json(['success' => true, 'message' => 'Product Type deleted']);
    }
}
