<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\ConversionProcess;
use Illuminate\Http\Request;


class ConversionProcessTypeController extends Controller
{
    public function index()
    {
        return view('admin.master.conversion_processes');
    }

    public function list()
    {
        $processes = ConversionProcess::all();
        return response()->json(['data' => $processes]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'process_name' => 'required|string|max:255',
        ]);

        $process = ConversionProcess::create($request->all());

        return response()->json(['success' => true, 'message' => 'Process added successfully']);
    }

    public function show($id)
    {
        $process = ConversionProcess::findOrFail($id);
        return response()->json($process);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'process_name' => 'required|string|max:255',
        ]);

        $process = ConversionProcess::findOrFail($id);
        $process->update($request->all());

        return response()->json(['success' => true, 'message' => 'Process updated successfully']);
    }

    public function destroy($id)
    {
        $process = ConversionProcess::findOrFail($id);
        $process->delete();

        return response()->json(['success' => true, 'message' => 'Process deleted successfully']);
    }
}
