<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CompanyType;
use Illuminate\Http\Request;

class CompanyTypeController extends Controller
{
    public function companyTypes()
    {
        return view('admin.master.companytype');
    }

    public function list()
    {
        $companytypes = CompanyType::select('id', 'companytype')->get();
        return response()->json(['data' => $companytypes]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'company_type' => 'required|string|max:255',
        ]);

        $companytype = CompanyType::create([
            'companytype' => $validated['company_type'],
        ]);

        return response()->json(['success' => true, 'message' => 'Company Type Added']);
    }

    public function update(Request $request, CompanyType $companytype)
    {
        $validated = $request->validate([
            'company_type' => 'required|string|max:255',
        ]);

        $companytype->update([
            'companytype' => $validated['company_type'],
        ]);

        return response()->json(['success' => true, 'message' => 'Company Type Updated']);
    }

    public function delete(CompanyType $companytype)
    {
        $companytype->delete();
        return response()->json(['success' => true, 'message' => 'Company Type Deleted']);
    }
}
