<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AccountType;

class AccountTypeController extends Controller
{
    public function index()
    {
        return view('admin.master.accounttype');
    }

    public function list()
    {
        $types = AccountType::select('id', 'accounttype')->get();
        return response()->json(['data' => $types]);
    }

    public function show(AccountType $accounttype)
    {
        // Return single account type for edit
        return response()->json($accounttype);
    }

    public function store(Request $request)
    {
        $request->validate(['account_type' => 'required']);
        AccountType::create(['accounttype' => $request->account_type]);
        return response()->json(['success' => true, 'message' => 'Account Type added']);
    }

    public function update(Request $request, AccountType $accounttype)
    {
        $request->validate(['account_type' => 'required']);
        $accounttype->update(['accounttype' => $request->account_type]);
        return response()->json(['success' => true, 'message' => 'Account Type updated']);
    }

    public function delete(AccountType $accounttype)
    {
        $accounttype->delete();
        return response()->json(['success' => true, 'message' => 'Account Type deleted']);
    }
}
