@extends('layouts.dashboard.superadminapp')

@section('title', 'Purchase Management')

@section('content')
    @include('v1.purchase.partials.styles')

    @include('v1.purchase.partials.header')

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="container-fluid">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Purchase Management 222</h5>
                <button class="btn btn-light btn-sm" id="addPurchaseInvoiceBtn">
                    <i class="fas fa-plus me-1"></i> Add New Purchase Invoice
                </button>
            </div>
            <div class="card-body">
                <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="pills-invoice-tab" data-toggle="pill"
                            href="#pills-invoice" role="tab"
                            onclick="loadPurchaseTableAgain()">Purchase Invoices</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="pills-payment-tab" data-toggle="pill"
                            href="#pills-payment" role="tab"
                            onclick="loadPaymentTableAgain()">Vendor Payments</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="pills-credit-tab" data-toggle="pill" href="#pills-credit"
                            role="tab">Credit Notes</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="pills-aging-tab" data-toggle="pill" href="#pills-aging"
                            role="tab">Aging Report</a>
                    </li>
                </ul>
                <div class="tab-content" id="pills-tabContent">
                    <!-- Purchase Invoices Tab -->
                    <div class="tab-pane fade show active" id="pills-invoice" role="tabpanel">
                        @include('v1.purchase.partials.filter')
                        @include('v1.purchase.partials.purchase-invoices-tab')
                    </div>
                    <!-- Vendor Payments Tab -->
                    <div class="tab-pane fade" id="pills-payment" role="tabpanel">
                        @include('v1.purchase.partials.vendor-payments-tab')
                    </div>
                    <!-- Credit Notes Tab -->
                    <div class="tab-pane fade" id="pills-credit" role="tabpanel">
                        @include('v1.purchase.partials.creditnotes-tab')
                    </div>
                    <!-- Aging Report Tab -->
                    <div class="tab-pane fade" id="pills-aging" role="tabpanel">
                        @include('v1.purchase.partials.age-reporting-tab')
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('v1.purchase.partials.newpurchaseinvoicemodal')


    @include('v1.purchase.partials.scripts')
@endsection 