@php
    $fields = [
        'stock_item' => ['label' => 'Stock Item', 'type' => 'select', 'readonly' => false ],
        'description' => ['label' => 'Description', 'type' => 'textarea'],
        'quantity' => ['label' => 'Quantity', 'type' => 'number', 'class' => 'quantity'],
        'uom' => ['label' => 'UOM', 'type' => 'text'],
        'supply_lead_time' => ['label' => 'Supply Lead Time','type' => 'text',],
        'unit_rate' => ['label' => 'Unit Rate (INR)', 'type' => 'number', 'class' => 'unit-rate'],
        'tds' => ['label' => 'TDS (%)', 'type' => 'number', 'class' => 'tds'],
        'discount' => ['label' => 'Discount (%)', 'type' => 'number', 'class' => 'discount'],
        'value' => ['label' => 'Value (INR)', 'type' => 'number', 'readonly' => true, 'class' => 'value'],
        'sgst' => ['label' => 'SGST (%)', 'type' => 'number', 'class' => 'sgst'],
        'cgst' => ['label' => 'CGST (%)', 'type' => 'number', 'class' => 'cgst'],
        'igst' => ['label' => 'IGST (%)', 'type' => 'number', 'class' => 'igst'],
        'amount' => ['label' => 'Amount (INR)', 'type' => 'number', 'readonly' => true, 'class' => 'amount'],
    ];
@endphp
<div class="pqo-list">
    <div class="table-responsive">
        <table id="pqoItems" class="table table-bordered poq-items-table w-100">
            <thead>
                <tr>
                    <th>Sl No.</th>
                    @foreach ($fields as $key => $field)
                        <th>{{ $field['label'] }}</th>
                    @endforeach
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody id="poItemsBody">
                @php $rowIndex = 0; @endphp
                @if (!empty($items) && count($items))
                    @foreach ($items as $item)
                        <tr>
                            <td>{{ $rowIndex + 1 }}</td>
                            @foreach ($fields as $key => $field)
                                <td>
                                    @if ($field['type'] === 'textarea')
                                        <textarea name="items[{{ $rowIndex }}][{{ $key }}]" class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }}" rows="1">{{ $item[$key] ?? '' }}</textarea>
                                    @elseif($field['type'] === 'select' && $key == 'stock_item')
                                        <select name="items[{{ $rowIndex }}][{{ $key }}]" class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }} stock-item-select selectpicker" data-live-search="true" data-width="100%">
                                            <option value="">Select Stock Item</option>
                                            @foreach ($stockItems as $stockItem)
                                                <option value="{{ $stockItem->id }}" 
                                                    {{ (isset($item[$key]) && $item[$key] == $stockItem->id) || (isset($item->stock_item) && $item->stock_item == $stockItem->id) ? 'selected' : '' }}>
                                                    {{ $stockItem->item_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @else
                                        <input 
                                            type="{{ $field['type'] }}" 
                                            name="items[{{ $rowIndex }}][{{ $key }}]" 
                                            class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }}" 
                                            value="{{ isset($field['transform']) && $field['transform'] ? $field['transform']($item[$key]) : $item[$key] ?? '' }}" 
                                            @if(isset($field['readonly']) && $field['readonly']) readonly @endif
                                        />
                                    @endif
                                </td>
                            @endforeach
                            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)"><i class="fa fa-trash"></i></button></td>
                        </tr>
                        @php $rowIndex++; @endphp
                    @endforeach
                @else
                    {{-- <tr>
                        <td>1</td>
                        @foreach ($fields as $key => $field)
                            <td>
                                @if ($field['type'] === 'textarea')
                                    <textarea name="items[0][{{ $key }}]" class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }}" rows="1"></textarea>
                                @else
                                    <input type="{{ $field['type'] }}" name="items[0][{{ $key }}]" class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }}" @if(isset($field['readonly']) && $field['readonly']) readonly @endif />
                                @endif
                            </td>
                        @endforeach
                        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)"><i class="fa fa-trash"></i></button></td>
                    </tr> --}}
                @endif
            </tbody>
        </table>
    </div>
    <div class="row mt-3">
        <div class="col-md-2">
            <!-- Bootstrap 4 modal trigger -->
            <button type="button" class="btn btn-primary" id="addRowBtn" data-toggle="modal" data-target="#addItemModal">Add Row</button>
        </div>
    </div>

    <!-- Comprehensive Aggregator View -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quotation Summary & Totals</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="amount-in-words">Amount in Words</label>
                                <input type="text" id="amount-in-words" class="form-control" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="totals-breakdown">
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="sub-total">Sub Total</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="sub_total" id="sub-total" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="total-discount">Total Discount</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="total_discount" id="total-discount" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2 d-none">
                                    <div class="col-md-4">
                                        <label for="total-sgst">Total SGST</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="total_sgst" id="total-sgst" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2 d-none">
                                    <div class="col-md-4">
                                        <label for="total-cgst">Total CGST</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="total_cgst" id="total-cgst" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2 d-none">
                                    <div class="col-md-4">
                                        <label for="total-igst">Total IGST</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="total_igst" id="total-igst" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="total-tds">Total TDS</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="total_tds" id="total-tds" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2 d-none">
                                    <div class="col-md-4">
                                        <label for="discount-amount">Discount Amount</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="discount_amount" id="discount-amount" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="additional-charges">Additional Charges</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="additional_charges" id="additional-charges" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="round-up">Round Up</label>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="round_up" id="round-up" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <strong><label for="grand-total">Grand Total</label></strong>
                                    </div>
                                    <div class="col-md-8">
                                        <input type="text" name="grand_total" id="grand-total" class="form-control" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function removeRow(btn) {
        const row = btn.closest('tr');
        row.parentNode.removeChild(row);
        updateRowNames();
    }
    function updateRowNames() {
        const rows = document.querySelectorAll('#poItemsBody tr');
        rows.forEach((row, idx) => {
            row.querySelector('td').innerText = idx + 1;
            row.querySelectorAll('input, textarea').forEach(input => {
                const name = input.getAttribute('name');
                if (name) {
                    const newName = name.replace(/items\[\d+\]/, 'items[' + idx + ']');
                    input.setAttribute('name', newName);
                }
            });
        });
    }
    // document.getElementById('addRowBtn').addEventListener('click', function() {
    //     const tbody = document.getElementById('poItemsBody');
    //     const rowCount = tbody.querySelectorAll('tr').length;
    //     let rowHtml = `<tr><td>${rowCount + 1}</td>`;
    //     @foreach ($fields as $key => $field)
    //         @if ($field['type'] === 'textarea')
    //             rowHtml += `<td><textarea name="items[${rowCount}][{{ $key }}]" class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }}" rows="1"></textarea></td>`;
    //         @else
    //             rowHtml += `<td><input type="{{ $field['type'] }}" name="items[${rowCount}][{{ $key }}]" class="form-control{{ isset($field['class']) ? ' ' . $field['class'] : '' }}" @if(isset($field['readonly']) && $field['readonly']) readonly @endif /></td>`;
    //         @endif
    //     @endforeach
    //     rowHtml += `<td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)"><i class="fa fa-trash"></i></button></td></tr>`;
    //     tbody.insertAdjacentHTML('beforeend', rowHtml);
    //     updateRowNames();
    // });

    // Modal calculation function
    function calculateModalValues() {
        var quantity = parseFloat(document.getElementById('modal-quantity').value) || 0;
        var unitRate = parseFloat(document.getElementById('modal-unit-rate').value) || 0;
        var tdsPercent = parseFloat(document.getElementById('modal-tds').value) || 0;
        var discountPercent = parseFloat(document.getElementById('modal-discount').value) || 0;
        var sgstPercent = parseFloat(document.getElementById('modal-sgst').value) || 0;
        var cgstPercent = parseFloat(document.getElementById('modal-cgst').value) || 0;
        var igstPercent = parseFloat(document.getElementById('modal-igst').value) || 0;

        // Auto-fill SGST and CGST based on TDS
        if (tdsPercent > 0) {
            var halfTds = tdsPercent / 2;
            var shouldAutofill = (sgstPercent === 0 && cgstPercent === 0);
            if (shouldAutofill) {
                document.getElementById('modal-sgst').value = halfTds.toFixed(2);
                document.getElementById('modal-cgst').value = halfTds.toFixed(2);
                sgstPercent = halfTds;
                cgstPercent = halfTds;
            }
        }

        var value = quantity * unitRate;
        var discount = value * discountPercent / 100;
        var sgst = (value - discount) * sgstPercent / 100;
        var cgst = (value - discount) * cgstPercent / 100;
        var igst = (value - discount) * igstPercent / 100;
        var amount = (value - discount) + sgst + cgst + igst;

        document.getElementById('modal-calculated-value').textContent = value.toFixed(2);
        document.getElementById('modal-calculated-amount').textContent = amount.toFixed(2);
    }

    function recalculateRow(row) {
        var quantity = parseFloat(row.querySelector('.quantity')?.value) || 0;
        var unitRate = parseFloat(row.querySelector('.unit-rate')?.value) || 0;
        var tdsPercent = parseFloat(row.querySelector('.tds')?.value) || 0;
        var discountPercent = parseFloat(row.querySelector('.discount')?.value) || 0;
        var sgstInput = row.querySelector('.sgst');
        var cgstInput = row.querySelector('.cgst');
        var sgstPercent = parseFloat(sgstInput?.value) || 0;
        var cgstPercent = parseFloat(cgstInput?.value) || 0;
        var igstPercent = parseFloat(row.querySelector('.igst')?.value) || 0;

        var value = quantity * unitRate;
        var discount = value * discountPercent / 100;
        var baseValue = value - discount;

        var sgst = baseValue * (sgstPercent / 100);
        var cgst = baseValue * (cgstPercent / 100);
        var igst = baseValue * (igstPercent / 100);
        var tds  = baseValue * (tdsPercent / 100);
        var amount = baseValue + sgst + cgst + igst - tds;

/*
        const base = quantity * unitRate * (1 - discountPercent / 100);
        const gstTotal = base * (sgstPercent + cgstPercent + igstPercent) / 100;
        const tdsAmount = base * (tdsPercent / 100);
        const total = base + gstTotal - tdsAmount;
*/

        if(row.querySelector('.value')) row.querySelector('.value').value = value.toFixed(2);
        if(row.querySelector('.amount')) row.querySelector('.amount').value = amount.toFixed(2);
    }

    function calculateTotals() {
        var subTotal = 0;
        var totalDiscount = 0;
        var totalSGST = 0;
        var totalCGST = 0;
        var totalIGST = 0;
        var totalTDS = 0;
        var additionalCharges = parseFloat(document.querySelector('#quotationContent #additionalCharges')?.value) || 0;

        document.querySelectorAll('#poItemsBody tr').forEach(function(row) {
            var quantity = parseFloat(row.querySelector('.quantity')?.value) || 0;
            var unitRate = parseFloat(row.querySelector('.unit-rate')?.value) || 0;
            var tdsPercent = parseFloat(row.querySelector('.tds')?.value) || 0;
            var discountPercent = parseFloat(row.querySelector('.discount')?.value) || 0;
            var sgstPercent = parseFloat(row.querySelector('.sgst')?.value) || 0;
            var cgstPercent = parseFloat(row.querySelector('.cgst')?.value) || 0;
            var igstPercent = parseFloat(row.querySelector('.igst')?.value) || 0;

/*
            const base = quantity * unitRate * (1 - discountPercent / 100);
            const gstTotal = base * (sgstPercent + cgstPercent + igstPercent) / 100;
            const tdsAmount = base * (tdsPercent / 100);
            const total = base + gstTotal - tdsAmount;
*/


            var value = quantity * unitRate;
            var discount = value * discountPercent / 100;
            var baseValue = value - discount;
            var sgst = baseValue * sgstPercent / 100;
            var cgst = baseValue * cgstPercent / 100;
            var igst = baseValue * igstPercent / 100;
            var tds = value * tdsPercent / 100;

            subTotal += baseValue;
            totalDiscount += discount;
            totalSGST += sgst;
            totalCGST += cgst;
            totalIGST += igst;
            totalTDS += tds;
        });

        // Update totals display
        document.getElementById('sub-total').value = subTotal.toFixed(2);
        document.getElementById('total-discount').value = totalDiscount.toFixed(2);
        document.getElementById('total-sgst').value = totalSGST.toFixed(2);
        document.getElementById('total-cgst').value = totalCGST.toFixed(2);
        document.getElementById('total-igst').value = totalIGST.toFixed(2);
        document.getElementById('total-tds').value = totalTDS.toFixed(2);
        document.getElementById('additional-charges').value = additionalCharges.toFixed(2);

        // Calculate quotation level discount
        var quotationDiscountPercent = parseFloat(document.getElementById('quotation-discount')?.value) || 0;
        var discountAmount = subTotal * quotationDiscountPercent / 100;
        document.getElementById('discount-amount').value = discountAmount.toFixed(2);

        // Calculate grand total
        var grandTotal = subTotal + totalSGST + totalCGST + totalIGST - discountAmount + additionalCharges - totalTDS;
        
        // Round up to nearest rupee
        var roundUp = Math.ceil(grandTotal) - grandTotal;
        document.getElementById('round-up').value = roundUp.toFixed(2);
        
        var finalGrandTotal = grandTotal + roundUp;
        document.getElementById('grand-total').value = finalGrandTotal.toFixed(2);

        // Update amount in words
        document.getElementById('amount-in-words').value = numberToWords(finalGrandTotal);
        document.querySelector('#quotationContent #inr_in_words').value = numberToWords(finalGrandTotal);
    }

    

    function attachAutoCalcListeners() {
        // clear the previous listeners
        document.querySelectorAll('#poItemsBody tr').forEach(function(row) {
            row.querySelectorAll('.quantity, .unit-rate, .tds, .discount, .sgst, .cgst, .igst').forEach(function(input) {
                if (input._rowInputListener) {
                    input.removeEventListener('input', input._rowInputListener);
                }
            });
        });

        // add the new listeners
        document.querySelectorAll('#poItemsBody tr').forEach(function(row) {
            row.querySelectorAll('.quantity, .unit-rate, .tds, .discount, .sgst, .cgst, .igst').forEach(function(input) {
                let rowInputListener = function() {
                    recalculateRow(row);
                    calculateTotals();
                };
                input.addEventListener('input', rowInputListener);
                input._rowInputListener = rowInputListener; // save reference
            });
        });
    }


    document.addEventListener('DOMContentLoaded', function() {
        // Initialize selectpicker for existing dropdowns
        $('.selectpicker').selectpicker();
        
        attachAutoCalcListeners();
        // Initial calculation for pre-filled rows
        document.querySelectorAll('#poItemsBody tr').forEach(recalculateRow);
        calculateTotals();
        console.log('document ready');
        // listen to the update event from the poitemmodal
        document.getElementById('pqoItems').addEventListener('update', function() {
            console.log('update event received');
            updateRowNames();
            calculateTotals();
            attachAutoCalcListeners();
            // Refresh selectpicker after update
            $('.selectpicker').selectpicker('refresh');
        });
    });
</script> 