<div class="filter-section">
    <div class="row">
        <div class="col-md-3">
            <label class="form-label">Date Range</label>
            <input type="text" class="form-control payment-date-range"
                placeholder="Select date range" readonly>
        </div>
        <div class="col-md-3">
            <label class="form-label">Party</label>
            <select class="form-select" id="payment-party" required>
                <option value="">Select Party</option>
                @foreach ($vendors as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->company }}</option>
                @endforeach

            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">Amount Range</label>
            <div class="input-group">
                <input type="number" class="form-control min-amount" placeholder="Min">
                <input type="number" class="form-control max-amount" placeholder="Max">
            </div>
        </div>
        <div class="col-md-3 d-flex align-items-end">
            <button class="btn btn-primary me-2" id="applyPaymentFilters">Apply Filters</button>
            <button class="btn btn-outline-secondary" id="resetPaymentFilters">Reset</button>
        </div>
    </div>
</div>

<table id="paymentTable" class="display nowrap table table-striped" style="width:100%">
    <thead>
        <tr>
            <th>Payment ID</th>
            <th>Invoice Date</th>
            <th>Purchase Date</th>
            <th>Party</th>
            <th>Invoice ID</th>
            <th>Purchase ID</th>
            <th>Amount</th>
            <th>Payment Mode</th>
            <th>Reference</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <!-- Data will be loaded here -->
    </tbody>
</table>