<!-- Purchase Orders Tab -->
<div class="table-responsive">
    <table id="purchaseInvoiceTable" class="table table-bordered table-striped w-100" >
        <thead>
            <tr>
                <th>Purchase No</th>
                <th>Purchase Date</th>
                <th>Vendor Invoice No</th>
                <th>Vendor</th>
                <th>Age</th>
                <th>Payment Status</th>
                <th>Items</th>
                <th>Subtotal</th>
                <th>Total Invoice Amount</th>
                <th>Total Paid Amount</th>
                <th>Total Balance Amount</th>
                <th>Status</th>
                <th>Action</th>
                <th>Files</th>
            </tr>
        </thead>
        <tbody>
            @if (isset($list) && count($list) > 0)
                @foreach ($list as $item)
                    <tr>
                        <td>{{ $item->purchase_no ?? '-' }}</td>
                        <td>{{ $item->purchase_date ? \Carbon\Carbon::parse($item->purchase_date)->format('d/m/Y') : '-' }}
                        </td>
                        <td>{{ $item->vendor_invoice_no ?? '-' }}</td>
                        <td>{{ $item->company_name ?? '-' }}</td>
                        <td>
                            @php
                                $age = $item->purchase_date ? \Carbon\Carbon::parse($item->purchase_date)->diffInDays(now()) : 0;
                                $age = $age < 0 ? 0 : ceil($age);
                            @endphp
                            {{ $age }} days
                        </td>
                        <td>{{ ucfirst($item->payment_status ?? 'unpaid') }}</td>
                        <td>{{ $item->items->count() ?? 0 }}</td>
                        <td>₹{{ number_format($item->subtotal ?? 0, 2) }}</td>
                        <td>₹{{ number_format($item->grand_total ?? 0, 2) }}</td>
                        <td>₹{{ number_format($item->paid_amount ?? 0, 2) }}</td>
                        <td>₹{{ number_format($item->balance_amount ?? 0, 2) }}</td>
                        <td>
                            @php
                                $status = $item->status ?? 'pending';
                                $statusClass = 'badge-secondary';
                                switch ($status) {
                                    case 'approved':
                                        $statusClass = 'badge-success';
                                        break;
                                    case 'rejected':
                                        $statusClass = 'badge-danger';
                                        break;
                                    case 'pending':
                                    default:
                                        $statusClass = 'badge-warning';
                                        break;
                                }
                            @endphp
                            <span class="badge {{ $statusClass }}">{{ ucfirst($status) }}</span>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('superadmin.purchase.v1.show', $item->id) }}"
                                    class="btn btn-sm btn-outline-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <button type="button" class="btn btn-sm btn-outline-success edit-purchase-invoice"
                                    data-id="{{ $item->id }}" data-row="{{ base64_encode(json_encode($item)) }}"
                                    title="Edit">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <!--<a href="{{ route('superadmin.purchase.v1.print', $item->id) }}"-->
                                <!--    class="btn btn-sm btn-outline-info" title="Print" target="_blank">-->
                                <!--    <i class="fas fa-print"></i>-->
                                <!--</a>-->
                                @if ($item->status === 'pending')
                                    <a href="{{ route('superadmin.purchase.v1.approve', $item->id) }}"
                                        class="btn btn-sm btn-outline-success" title="Approve"
                                        onclick="return confirm('Are you sure you want to approve this purchase order?')">
                                        <i class="fas fa-check"></i>
                                    </a>
                                    <a href="{{ route('superadmin.purchase.v1.reject', $item->id) }}"
                                        class="btn btn-sm btn-outline-danger" title="Reject"
                                        onclick="return confirm('Are you sure you want to reject this purchase order?')">
                                        <i class="fas fa-times"></i>
                                    </a>
                                @endif
                                <button type="button" class="btn btn-sm btn-outline-primary create-credit-note"
                                    data-invoice="{{ $item->purchase_no }}" 
                                    data-vendor="{{ $item->vendor_id }}" 
                                    data-vendor-name="{{ $item->company_name }}"
                                    title="Create Credit Note">
                                    <i class="fas fa-file-invoice"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-danger delete-purchase-invoice"
                                    data-id="{{ $item->id }}" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                        <td>
                            <div class="btn-group" role="group">
                                @foreach($item->files as $file)
                                    <a href="{{ asset('storage/' . $file->file_path) }}" target="_blank"
                                        class="btn btn-sm btn-outline-info" title="View">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.purchase.v1.deleteFile', ['id' => $file->id]) }}" 
                                        class="btn btn-sm btn-outline-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                @endforeach
                            </div>
                        </td>
                    </tr>
                @endforeach    
            @endif
        </tbody>
    </table>
</div>

<!-- Pagination -->
@if(isset($list) && $list instanceof \Illuminate\Pagination\LengthAwarePaginator)
<div class="mt-3">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            Showing {{ $list->firstItem() }} to {{ $list->lastItem() }} of {{ $list->total() }} entries
        </div>
        <div>
            {{ $list->appends(request()->query())->links() }}
        </div>
    </div>
</div>
@endif

@push('scripts')
    <script>
        // Handle pagination clicks
        $(document).on('click', '.pagination a', function(e) {
            e.preventDefault();
            const url = $(this).attr('href');
            if (url) {
                // Get current filter values
                const formData = $('#filterForm').serialize();
                const urlObj = new URL(url, window.location.origin);
                const pageParam = urlObj.searchParams.get('page');
                
                // Combine filters with page parameter
                const combinedData = formData + (formData ? '&' : '') + 'page=' + pageParam;
                
                $('#purchase-table-container').html('<div class="text-center p-5"><i class="fas fa-spinner fa-spin fa-3x"></i><p class="mt-3">Loading...</p></div>');
                
                $.ajax({
                    url: '{{ route("superadmin.purchase.v1.index") }}',
                    type: 'GET',
                    data: combinedData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#purchase-table-container').html(response.html);
                            
                            // Reinitialize DataTable
                            if ($.fn.DataTable.isDataTable('#purchaseInvoiceTable')) {
                                $('#purchaseInvoiceTable').DataTable().destroy();
                            }
                            $('#purchaseInvoiceTable').DataTable({
                                dom: 'Bfrtip',
                                buttons: [
                                    'copy', 'csv', 'excel', 'pdf', 'print', 'colvis'
                                ],
                                responsive: true,
                                paging: false,
                                info: false
                            });
                        }
                    },
                    error: function(xhr) {
                        console.error('Error loading page:', xhr);
                        $('#purchase-table-container').html('<div class="alert alert-danger">Error loading data. Please try again.</div>');
                    }
                });
            }
        });
        
        // Initialize DataTable if not already done
        if (typeof initializePurchaseDataTable === 'undefined') {
            window.initializePurchaseDataTable = function() {
                if ($.fn.DataTable.isDataTable('#purchaseInvoiceTable')) {
                    $('#purchaseInvoiceTable').DataTable().destroy();
                }
                $('#purchaseInvoiceTable').DataTable({
                    dom: 'Bfrtip',
                    buttons: [
                        'copy', 'csv', 'excel', 'pdf', 'print', 'colvis'
                    ],
                    responsive: true,
                    paging: false, // Disable DataTable pagination as we use Laravel pagination
                    info: false
                });
            };
        }
        
        // Initialize on load
        setTimeout(initializePurchaseDataTable, 100);
    </script>
@endpush
